var name = "stream-v3";
var rev = true;
var tmp = localStorage.getItem(name) === null ? [] : JSON.parse(localStorage.getItem(name));
var layout = localStorage.getItem("layout") === null ? 1 : localStorage.getItem("layout");
var maxSpins = localStorage.getItem("maxSpins") === null ? 1000 : localStorage.getItem("maxSpins");
var counter;
var counter2 = 0;
var wheelorder2 = [5, 24, 16, 33, 1, 20, 14, 31, 9, 22, 18, 29, 7, 28, 12, 35, 3, 26, 0, 32, 15, 19, 4, 21, 2, 25, 17, 34, 6, 27, 13, 36, 11, 30, 8, 23, 10];
var wheelorder = [0, 32, 15, 19, 4, 21, 2, 25, 17, 34, 6, 27, 13, 36, 11, 30, 8, 23, 10, 5, 24, 16, 33, 1, 20, 14, 31, 9, 22, 18, 29, 7, 28, 12, 35, 3, 26];
var rednums = [1, 3, 5, 7, 9, 12, 14, 16, 18, 19, 21, 23, 25, 27, 30, 32, 34, 36];
var nums = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
var spinscount, uniquecount, unhitcount, repeatercount, redcount, blackcount, zerocount, d1count, d2count, d3count, c1count, c2count, c3count, highcount, lowcount, evencount, oddcount;

var stream = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36];
var streamSplit = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18];
var streamStreet = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
var streamLine = [1, 2, 3, 4, 5, 6];
var streamQuad = [1, 2, 3, 4];
var streamDoz = [1, 2, 3];
var streamCol = [1, 2, 3];
var streamHL = ['L', 'H'];

var cHL = [];
var cDoz = [];
var cQuad = [];
var cLine = [];
var cStreet = [];
var cSplit = [];
var cStreight = [];

var pcHL = [];
var pcDoz = [];
var pcQuad = [];
var pcLine = [];
var pcStreet = [];
var pcSplit = [];
var pcStreight = [];

loadBoard();
loadNav();
loadTable();
loadStreams();

function loadBoard() {
	$(".board").append('<div id="n0" class="box zero">0</div>');

	for (i = 3; i <= 36; i = i + 3) {
		$(".board").append('<div id="n' + i + '" class="box ' + getNumColor(i) + '">' + i + "</div>");
	}

	for (i = 2; i <= 35; i = i + 3) {
		$(".board").append('<div id="n' + i + '" class="box ' + getNumColor(i) + '">' + i + "</div>");
	}

	for (i = 1; i <= 34; i = i + 3) {
		$(".board").append('<div id="n' + i + '" class="box ' + getNumColor(i) + '">' + i + "</div>");
	}

	boardButtons();
}

function loadTable() {
	$(".table").html('');

	$(".table").append('<div class="hits"><div class="fillbox">&nbsp;</div></div>');

	for (i = 1; i <= 14; i++) {
		$(".table .hits").append('<div class="box">' + i + '</div>');
	}
	$(".table .hits").append('<div class="box">...</div>');

	if (layout == 1) {
		for (i = 0; i <= 36; i++) {
			$(".table").append(
				'<div id="col' + i + '"><div class="head ' + getNumColor(i) + '">' + i + '</div><div class="col"></div></div>'
			);

			for (j = 0; j <= 14; j++) {
				$('#col' + i + ' .col').append('<div class="fillbox f' + j + '">&nbsp;</div>');
			}
		}
	} else {

		for (i = 19; i <= 36; i++) {
			$(".table").append(
				'<div id="col' + wheelorder[i] + '"><div class="head ' + getNumColor(wheelorder[i]) + '">' + wheelorder[i] + '</div><div class="col"></div></div>'
			);
		}

		$(".table").append(
			'<div id="col0"><div class="head green">0</div><div class="col"></div></div>'
		);

		for (i = 1; i <= 18; i++) {
			$(".table").append(
				'<div id="col' + wheelorder[i] + '"><div class="head ' + getNumColor(wheelorder[i]) + '">' + wheelorder[i] + '</div><div class="col"></div></div>'
			);
		}

		for (i = 0; i <= 36; i++) {
			for (j = 0; j <= 14; j++) {
				$('#col' + wheelorder[i] + ' .col').append('<div class="fillbox f' + j + '">&nbsp;</div>');
			}
		}

		//		for (i = 0; i <= 36; i++) {
		//			$(".table").append(
		//				'<div id="col' + wheelorder[i] + '"><div class="head">' + wheelorder[i] + '</div><div class="col"></div></div>'
		//			);
		//
		//			for (j = 0; j <= 14; j++) {
		//				$('#col' + wheelorder[i] + ' .col').append('<div class="fillbox f' + j + '">&nbsp;</div>');
		//			}
		//		}
	}

	fillTable();
	updateHistory();
	updateStats();
	updateStatsBox();
	updateMarks();
	updateStream();
}

function getNumColor(i) {
	var x = parseInt(i);
	return x === 0 ? "green" : rednums.indexOf(x) == -1 ? "black" : "red";
}

function getTableColor() {
	return "color" + (Math.floor((counter - 1) / 37) + 3) % 15;
	//	return "color" + Math.ceil(counter / 37);
}

function boardButtons() {
	$(".board .box").click(function () {
		insertIntoTable($(this).html());
	});

	$('.stats .head').click(function () {

		switch ($(this).html()) {
			case "UNH":
				$(this).toggleClass('mark1');
				break;
			case "UNQ":
				$(this).toggleClass('mark2');
				break;
			case "REP":
				$(this).toggleClass('mark3');
				break;
		}

		updateMarks();
	});
}

function insertIntoTable(number) {
	//$(".table #col" + number).append(
	//	'<div class="' + getTableColor() + ' box">' + counter + "</div>"
	//);
	tmp.push(number);
	loadTable();
	saveData();
	//	updateStatsBox(number);
}

function fillTable() {
	counter = 1;

	if (tmp.length > maxSpins)
		tmp.splice(0, tmp.length - maxSpins);

	for (var i in tmp) {
		$(".table #col" + tmp[i] + ' .col .f0').before(
			'<div class="' + getBoxSize() + ' ' + getTableColor() + '">' + counter + "</div>"
		);
		counter++;
	}
	updateCounter();
}

function getBoxSize() {
	return (counter < 100) ? 'box' : 'boxsmall';
}

function updateCounter() {
	counter = tmp.length + 1;
}

function saveData() {
	localStorage.setItem(name, JSON.stringify(tmp));
}

function loadNav() {
	$(".nav #undo").click(undo);
	$(".nav #reset").click(reset);
	$(".nav #switchlayout").click(switchLayout);
	$(".nav #screenshot").click(screenshot);
	$(".nav #random").click(random);
	$(".nav #importExport").click(importExport);
	$(".nav #config").click(config);

	$('#order').click(function () {
		rev = !rev;
		updateStream();
	});
}

function undo() {
	tmp.pop();
	loadTable();
	saveData();
}

function reset() {
	if (confirm('Are you sure you want to reset your tracking records?')) {
		tmp = [];
		loadTable();
		saveData();
	}
}

function switchLayout() {
	layout = (layout == 1) ? 2 : 1;
	localStorage.setItem("layout", layout);
	loadTable();
}

function screenshot() {
	html2canvas(document.querySelector("body .table"), {
		scale: 2,
		logging: false
	}).then(function (canvas) {
		var d = new Date();
		var filename = d.toISOString().slice(0, 10).replace(/-/g, "");
		filename += '-' + addZero(d.getHours());
		filename += addZero(d.getMinutes());
		filename += addZero(d.getSeconds()) + '.png';
		$('#download').attr('href', canvas.toDataURL('image/png'));
		$('#download').attr('download', filename);
		$('#download')[0].click();
	});
}

function random() {
	$.get("https://www.random.org/integers/?num=100&min=1&max=36&col=1&base=10&format=plain&rnd=new", function (data) {
		//	$.get("https://www.random.org/integers/?num=20&min=1&max=36&col=1&base=10&format=plain&rnd=new", function (data) {
		tmp = data.split("\n");
		tmp = tmp.filter(function (x) {
			return x.length && x == +x && x[0] != '-' && x <= 36;
		});
		loadTable();
		saveData();
	});
}

function importSpins() {
	if ($('#importExportValue').val()) {
		var tee = $('#importExportValue').val().replace(/[\t ]/g, "");
		tee = tee.split("\n");
		tee = tee.filter(function (x) {
			return x.length && x == +x && x[0] != '-' && x <= 36;
		});

		if (tee.length > 0) {
			tmp = tee;
			loadTable();
			saveData();
		}
	}
	$('#importExportValue').val('');
	remove();
}


function exportSpins() {
	$("#importExportValue").val(tmp.join('\n'));

	$("#importExportValue").focus(function () {
		$(this).mouseup(function () {
			$(this).unbind("mouseup");
			$(this).select();
			return false;
		});
	});
}

function importExport() {
	uglipop({
		class: 'dialog',
		source: 'html',
		content: '<ul class="nav"><li id="importSpins">Import</li><li id="exportSpins">Export</li><li id="dialogDone">Done</li></ul><textarea rows="20" cols="26" id="importExportValue"></textarea>'
	});

	$("#importSpins").click(importSpins);
	$("#exportSpins").click(exportSpins);
	$("#dialogDone").click(remove);
}

function setMaxSpins() {
	if (parseInt($("#maxSpins").val()) > 0) {
		maxSpins = parseInt($("#maxSpins").val());
		localStorage.setItem("maxSpins", maxSpins);
		loadTable();
	}
	remove();
}

function config() {
	uglipop({
		class: 'dialog',
		source: 'html',
		content: '<ul class="nav"><li style="margin-left: 10px;" id="ok">OK</li><li style="margin-right: 10px;" id="cancle">Cancle</li></ul><div style="text-align: center;">Max spins to track:</div><input type="number" id="maxSpins" />'
	});

	$("#maxSpins").val(maxSpins);
	$("#ok").click(setMaxSpins);
	$("#cancle").click(remove);
}

function updateHistory() {
	$(".history").html('');

	var i;
	if (tmp.length <= 37) {
		for (i in tmp) {
			$(".history").prepend('<div class="box ' + getNumColor(tmp[i]) + '">' + tmp[i] + '</div>');
		}
	} else {
		for (i = tmp.length - 1; i >= tmp.length - 37; i--) {
			$(".history").append('<div class="box ' + getNumColor(tmp[i]) + '">' + tmp[i] + '</div>');
		}
	}
}

function addZero(i) {
	return (i < 10) ? "0" + i : i;
}

function addSpace(i) {
	return (i < 10) ? "&nbsp;" + i : i;
}

function updateStats() {
	spinscount = tmp.length;

	unhitcount = 0;
	uniquecount = 0;
	repeatercount = 0;

	redcount = 0;
	blackcount = 0;
	zerocount = 0;

	lowcount = 0;
	highcount = 0;

	evencount = 0;
	oddcount = 0;

	d1count = 0;
	d2count = 0;
	d3count = 0;

	c1count = 0;
	c2count = 0;
	c3count = 0;

	nums.fill(0);

	tmp.forEach(function (x) {
		nums[x] = nums[x] + 1;

		c1count += (x > 0 && x < 13) ? 1 : 0;
		c2count += (x > 12 && x < 25) ? 1 : 0;
		c3count += (x > 24) ? 1 : 0;

		d1count += (x > 0 && parseInt(x) % 3 == 1) ? 1 : 0;
		d2count += (x > 0 && parseInt(x) % 3 == 2) ? 1 : 0;
		d3count += (x > 0 && parseInt(x) % 3 == 0) ? 1 : 0;

		lowcount += (x > 0 && x < 19) ? 1 : 0;
		highcount += (x > 0 && x > 18) ? 1 : 0;

		evencount += (x > 0 && parseInt(x) % 2 == 0) ? 1 : 0;
		oddcount += (x > 0 && parseInt(x) % 2 == 1) ? 1 : 0;

		if (x == 0) {
			zerocount++;
		} else if (rednums.indexOf(parseInt(x)) != -1) {
			redcount++;
		} else {
			blackcount++;
		}
	});

	$('#unhits').html('');
	$('#uniques').html('');
	$('#repeaters').html('');

	for (i = 0; i <= nums.length - 1; i++) {
		if (nums[i] == 0)
			$('#unhits').append(i + ' ');
		else if (nums[i] == 1)
			$('#uniques').append(i + ' ');
		else
			$('#repeaters').append(i + ' ');
	}

	nums.forEach(function (x) {
		unhitcount += (x == 0) ? 1 : 0;
		uniquecount += (x == 1) ? 1 : 0;
		repeatercount += (x > 1) ? 1 : 0;
	});

	$('#spin').html(spinscount);
	$('#high').html('HI: ' + highcount);
	$('#low').html('LO: ' + lowcount);
	$('#even').html('EV: ' + evencount);
	$('#odd').html('OD: ' + oddcount);
	$('#red').html(redcount);
	$('#black').html(blackcount);
	$('#zero').html(zerocount);

	$('#column1').html(c1count);
	$('#column2').html(c2count);
	$('#column3').html(c3count);
	$('#dozen1').html(d1count);
	$('#dozen2').html(d2count);
	$('#dozen3').html(d3count);

	//	$('#unhit').html('UNH: ' + addSpace(unhitcount));
	//	$('#unique').html('UNQ: ' + addSpace(uniquecount));
	//	$('#repeater').html('REP: ' + addSpace(repeatercount));

	$('#unhit').html(unhitcount);
	$('#unique').html(uniquecount);
	$('#repeater').html(repeatercount);

	$('#unhunqdiff').html(Math.abs(unhitcount - uniquecount));
	$('#unqrepdiff').html(Math.abs(uniquecount - repeatercount));
}

function updateStatsBox() {
	var num;
	counter = 1;

	$(".statsboxBody .col").html('');

	for (var i in tmp) {
		num = parseInt(tmp[i]);

		$("#spins").prepend('<div class="box white">' + counter + '</div>');
		$("#num").prepend('<div class="' + getNumColor(tmp[i]) + ' box">' + tmp[i] + '</div>');

		if (num == 0) {
			$("#eo").prepend('<div class="box green">0</div>');
			$("#hlt").prepend('<div class="box green">0</div>');
			$("#hlw").prepend('<div class="box green">0</div>');
			$("#ct").prepend('<div class="box green">0</div>');
			$("#cw").prepend('<div class="box green">0</div>');
			$("#dt").prepend('<div class="box green">0</div>');
			$("#dw").prepend('<div class="box green">0</div>');
			$("#st").prepend('<div class="box green">0</div>');
			$("#sw").prepend('<div class="box green">0</div>');
			$("#lt").prepend('<div class="box green">0</div>');
			$("#lw").prepend('<div class="box green">0</div>');
			$("#spt").prepend('<div class="box green">0</div>');
			$("#spw").prepend('<div class="box green">0</div>');
			$("#set").prepend('<div class="box green">0</div>');
			$("#sew").prepend('<div class="box green">0</div>');
		} else {
			if (num % 2 == 1)
				$("#eo").prepend('<div class="box color0">O</div>');
			else
				$("#eo").prepend('<div class="box color1">E</div>');

			if (num < 19)
				$("#hlt").prepend('<div class="box color0">L</div>');
			else
				$("#hlt").prepend('<div class="box color1">H</div>');

			if (wheelorder.indexOf(num) < 19)
				$("#hlw").prepend('<div class="box color0">L</div>');
			else
				$("#hlw").prepend('<div class="box color1">H</div>');

			$("#dt").prepend('<div class="box color' + (Math.ceil(num / 12) - 1) + '">' + Math.ceil(num / 12) + '</div>');
			$("#dw").prepend('<div class="box color' + (Math.ceil(wheelorder.indexOf(num) / 12) - 1) + '">' + Math.ceil(wheelorder.indexOf(num) / 12) + '</div>');

			if (num % 3 == 1) {
				$("#ct").prepend('<div class="box color0">1</div>');
				$("#set").prepend('<div class="box color' + ((Math.ceil(num / 12) - 1) * 3) + '">' + ((Math.ceil(num / 12) - 1) * 3 + 1) + '</div>');
				$("#spt").prepend('<div class="box color' + ((Math.ceil(num / 6) - 1) * 3) + '">' + ((Math.ceil(num / 6) - 1) * 3 + 1) + '</div>');
			} else if (num % 3 == 2) {
				$("#ct").prepend('<div class="box color1">2</div>');
				$("#set").prepend('<div class="box color' + ((Math.ceil(num / 12) - 1) * 3 + 1) + '">' + ((Math.ceil(num / 12) - 1) * 3 + 2) + '</div>');
				$("#spt").prepend('<div class="box color' + ((Math.ceil(num / 6) - 1) * 3 + 1) + '">' + ((Math.ceil(num / 6) - 1) * 3 + 2) + '</div>');
			} else {
				$("#ct").prepend('<div class="box color2">3</div>');
				$("#set").prepend('<div class="box color' + ((Math.ceil(num / 12) - 1) * 3 + 2) + '">' + ((Math.ceil(num / 12) - 1) * 3 + 3) + '</div>');
				$("#spt").prepend('<div class="box color' + ((Math.ceil(num / 6) - 1) * 3 + 2) + '">' + ((Math.ceil(num / 6) - 1) * 3 + 3) + '</div>');
			}


			if (wheelorder.indexOf(num) % 3 == 1) {
				$("#cw").prepend('<div class="box color0">1</div>');
				$("#sew").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3 + 1) + '</div>');
				$("#spw").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3 + 1) + '</div>');
			} else if (wheelorder.indexOf(num) % 3 == 2) {
				$("#cw").prepend('<div class="box color1">2</div>');
				$("#sew").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3 + 1) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3 + 2) + '</div>');
				$("#spw").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3 + 1) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3 + 2) + '</div>');
			} else {
				$("#cw").prepend('<div class="box color2">3</div>');
				$("#sew").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3 + 2) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 12) - 1) * 3 + 3) + '</div>');
				$("#spw").prepend('<div class="box color' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3 + 2) + '">' + ((Math.ceil(wheelorder.indexOf(num) / 6) - 1) * 3 + 3) + '</div>');
			}



			$("#lt").prepend('<div class="box color' + (Math.ceil(num / 6) - 1) + '">' + Math.ceil(num / 6) + '</div>');
			$("#lw").prepend('<div class="box color' + (Math.ceil(wheelorder.indexOf(num) / 6) - 1) + '">' + Math.ceil(wheelorder.indexOf(num) / 6) + '</div>');

			$("#st").prepend('<div class="box color' + (Math.ceil(num / 3) - 1) + '">' + Math.ceil(num / 3) + '</div>');
			$("#sw").prepend('<div class="box color' + (Math.ceil(wheelorder.indexOf(num) / 3) - 1) + '">' + Math.ceil(wheelorder.indexOf(num) / 3) + '</div>');

		}
		counter++;
	}
}

function updateMarks() {
	$('.board .mark1').removeClass('mark1');
	$('.board .mark2').removeClass('mark2');
	$('.board .mark3').removeClass('mark3');

	$('.stats .head').each(function () {
		if ($(this).hasClass('mark1') || $(this).hasClass('mark2') || $(this).hasClass('mark3')) {
			switch ($(this).html()) {
				case "UNH":
					$('.board').children().each(function () {
						if (nums[parseInt($(this).html())] == 0)
							$(this).addClass('mark1');
					});
					break;
				case "UNQ":
					$('.board').children().each(function () {
						if (nums[parseInt($(this).html())] == 1)
							$(this).addClass('mark2');
					});
					break;
				case "REP":
					$('.board').children().each(function () {
						if (nums[parseInt($(this).html())] >= 2)
							$(this).addClass('mark3');
					});
					break;
			}
		}
	});

}

function updateStream() {
	var spin = 0;
	var ayk = [];

	var n = [0, 0];
	var highlow = [0, 0];
	var doz = [0, 0];
	var col = [0, 0];
	var quad = [0, 0];
	var line = [0, 0];
	var street = [0, 0];
	var split = [0, 0];
	var clHL;
	var clDoz;
	var clQuad;
	var clLine;
	var clStreet;
	var clSplit;
	var clStreight;
	var pclHL;
	var pclDoz;
	var pclQuad;
	var pclLine;
	var pclStreet;
	var pclSplit;
	var pclStreight;

	//	for (var x = 1; x <= stream.length; x++)
	//		stream[x - 1] = x;

	stream = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36];
	streamSplit = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18];
	streamStreet = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12];
	streamLine = [1, 2, 3, 4, 5, 6];
	streamQuad = [1, 2, 3, 4];
	streamDoz = [1, 2, 3];
	streamCol = [1, 2, 3];
	streamHL = ['L', 'H'];

	cHL = [];
	cDoz = [];
	cQuad = [];
	cLine = [];
	cStreet = [];
	cSplit = [];
	cStreight = [];

	pcHL = [];
	pcDoz = [];
	pcQuad = [];
	pcLine = [];
	pcStreet = [];
	pcSplit = [];
	pcStreight = [];


	// $('.stream .row').remove();
	//	$('.stream').prepend('<div class="row"></div>');
	//
	//	for (var i in stream) {
	//		$('.stream .row:first-child').append('<div>' + stream[i] + '</div>');
	//	}



	for (i in tmp) {
		spin++;

		if (parseInt(tmp[i]) == 0) {

			if (rev) {

				ayk.unshift('</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div style="margin-right: 2px" class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="green">0</div>');
				ayk.unshift('<div class="white">' + spin + '</div>');
				ayk.unshift('<div class="row">');

			} else {
				ayk.push('<div class="row">');
				ayk.push('<div class="white">' + spin + '</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div style="margin-right: 2px" class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('<div class="green">0</div>');
				ayk.push('</div>');
			}



			//			$('.stream .row:last-child').append('<div class="stream-streight"></div>');
			//			for (var j in stream) {
			//				$('.stream .row:last-child .stream-streight').append('<div class="white">' + stream[j] + '</div>');
			//			}

		} else {

			n[0] = parseInt(tmp[i]);
			highlow[0] = (n[0] <= 18) ? 'L' : 'H';
			doz[0] = Math.ceil(n[0] / 12);
			col[0] = (n[0] + 2) % 3 + 1;
			quad[0] = Math.ceil(n[0] / 9);
			line[0] = Math.ceil(n[0] / 6);
			street[0] = Math.ceil(n[0] / 3);
			split[0] = (line[0] - 1) * 3 + col[0];

			n[1] = stream.indexOf(n[0]) + 1;
			// highlow[1] = streamHL.indexOf(highlow[0]) + 1;
			highlow[1] = (streamHL.indexOf(highlow[0]) + 1) == 1 ? 'L' : 'H';
			doz[1] = streamDoz.indexOf(doz[0]) + 1;
			col[1] = streamCol.indexOf(col[0]) + 1;
			quad[1] = streamQuad.indexOf(quad[0]) + 1;
			line[1] = streamLine.indexOf(line[0]) + 1;
			street[1] = streamStreet.indexOf(street[0]) + 1;
			split[1] = streamSplit.indexOf(split[0]) + 1;

			stream.some(function (item, pos) {
				if (item == n[0]) {
					stream.splice(pos, 1);
					stream.unshift(item);
					return true;
				}
			});

			streamHL.some(function (item, pos) {
				if (item == highlow[0]) {
					streamHL.splice(pos, 1);
					streamHL.unshift(item);
					return true;
				}
			});

			streamDoz.some(function (item, pos) {
				if (item == doz[0]) {
					streamDoz.splice(pos, 1);
					streamDoz.unshift(item);
					return true;
				}
			});

			streamCol.some(function (item, pos) {
				if (item == col[0]) {
					streamCol.splice(pos, 1);
					streamCol.unshift(item);
					return true;
				}
			});

			streamQuad.some(function (item, pos) {
				if (item == quad[0]) {
					streamQuad.splice(pos, 1);
					streamQuad.unshift(item);
					return true;
				}
			});

			streamLine.some(function (item, pos) {
				if (item == line[0]) {
					streamLine.splice(pos, 1);
					streamLine.unshift(item);
					return true;
				}
			});

			streamStreet.some(function (item, pos) {
				if (item == street[0]) {
					streamStreet.splice(pos, 1);
					streamStreet.unshift(item);
					return true;
				}
			});

			streamSplit.some(function (item, pos) {
				if (item == split[0]) {
					streamSplit.splice(pos, 1);
					streamSplit.unshift(item);
					return true;
				}
			});

			// CL

			if (cHL.indexOf(highlow[0]) == -1) {
				clHL = '';
				cHL.push(highlow[0]);
			} else {
				clHL = cHL.length;
				cHL = [];
				cHL.push(highlow[0]);
			}

			if (pcHL.indexOf(highlow[1]) == -1) {
				pclHL = '';
				pcHL.push(highlow[1]);
			} else {
				pclHL = pcHL.length;
				pcHL = [];
				pcHL.push(highlow[1]);
			}

			if (cDoz.indexOf(doz[0]) == -1) {
				clDoz = '';
				cDoz.push(doz[0]);
			} else {
				clDoz = cDoz.length;
				cDoz = [];
				cDoz.push(doz[0]);
			}

			if (pcDoz.indexOf(doz[1]) == -1) {
				pclDoz = '';
				pcDoz.push(doz[1]);
			} else {
				pclDoz = pcDoz.length;
				pcDoz = [];
				pcDoz.push(doz[1]);
			}

			if (cQuad.indexOf(quad[0]) == -1) {
				clQuad = '';
				cQuad.push(quad[0]);
			} else {
				clQuad = cQuad.length;
				cQuad = [];
				cQuad.push(quad[0]);
			}

			if (pcQuad.indexOf(quad[1]) == -1) {
				pclQuad = '';
				pcQuad.push(quad[1]);
			} else {
				pclQuad = pcQuad.length;
				pcQuad = [];
				pcQuad.push(quad[1]);
			}

			if (cLine.indexOf(line[0]) == -1) {
				clLine = '';
				cLine.push(line[0]);
			} else {
				clLine = cLine.length;
				cLine = [];
				cLine.push(line[0]);
			}

			if (pcLine.indexOf(line[1]) == -1) {
				pclLine = '';
				pcLine.push(line[1]);
			} else {
				pclLine = pcLine.length;
				pcLine = [];
				pcLine.push(line[1]);
			}

			if (cStreet.indexOf(street[0]) == -1) {
				clStreet = '';
				cStreet.push(street[0]);
			} else {
				clStreet = cStreet.length;
				cStreet = [];
				cStreet.push(street[0]);
			}

			if (pcStreet.indexOf(street[1]) == -1) {
				pclStreet = '';
				pcStreet.push(street[1]);
			} else {
				pclStreet = pcStreet.length;
				pcStreet = [];
				pcStreet.push(street[1]);
			}

			if (cSplit.indexOf(split[0]) == -1) {
				clSplit = '';
				cSplit.push(split[0]);
			} else {
				clSplit = cSplit.length;
				cSplit = [];
				cSplit.push(split[0]);
			}

			if (pcSplit.indexOf(split[1]) == -1) {
				pclSplit = '';
				pcSplit.push(split[1]);
			} else {
				pclSplit = pcSplit.length;
				pcSplit = [];
				pcSplit.push(split[1]);
			}

			if (cStreight.indexOf(n[0]) == -1) {
				clStreight = '';
				cStreight.push(n[0]);
			} else {
				clStreight = cStreight.length;
				cStreight = [];
				cStreight.push(n[0]);
			}

			if (pcStreight.indexOf(n[1]) == -1) {
				pclStreight = '';
				pcStreight.push(n[1]);
			} else {
				pclStreight = pcStreight.length;
				pcStreight = [];
				pcStreight.push(n[1]);
			}

			if (rev) {
				ayk.unshift('</div>');
				ayk.unshift('<div class="white">' + pclHL + '</div>');
				ayk.unshift('<div class="color' + highlow[1] + '">' + highlow[1] + '</div>');
				ayk.unshift('<div class="white">' + clHL + '</div>');
				ayk.unshift('<div class="color' + highlow[0] + '">' + highlow[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclDoz + '</div>');
				ayk.unshift('<div class="color' + (doz[1] - 1) + '">' + doz[1] + '</div>');
				ayk.unshift('<div class="white">' + clDoz + '</div>');
				ayk.unshift('<div class="color' + (doz[0] - 1) + '">' + doz[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclQuad + '</div>');
				ayk.unshift('<div class="color' + (quad[1] - 1) + '">' + quad[1] + '</div>');
				ayk.unshift('<div class="white">' + clQuad + '</div>');
				ayk.unshift('<div class="color' + (quad[0] - 1) + '">' + quad[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclLine + '</div>');
				ayk.unshift('<div class="color' + (line[1] - 1) + '">' + line[1] + '</div>');
				ayk.unshift('<div class="white">' + clLine + '</div>');
				ayk.unshift('<div class="color' + (line[0] - 1) + '">' + line[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclStreet + '</div>');
				ayk.unshift('<div class="color' + (street[1] - 1) + '">' + street[1] + '</div>');
				ayk.unshift('<div class="white">' + clStreet + '</div>');
				ayk.unshift('<div class="color' + (street[0] - 1) + '">' + street[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclSplit + '</div>');
				ayk.unshift('<div class="color' + (split[1] - 1) + '">' + split[1] + '</div>');
				ayk.unshift('<div class="white">' + clSplit + '</div>');
				ayk.unshift('<div class="color' + (split[0] - 1) + '">' + split[0] + '</div>');
				ayk.unshift('<div style="margin-right: 2px" class="white">' + pclStreight + '</div>');
				ayk.unshift('<div class="' + getNumColor(n[1]) + '">' + n[1] + '</div>');
				ayk.unshift('<div class="white">' + clStreight + '</div>');
				ayk.unshift('<div class="' + getNumColor(n[0]) + '">' + n[0] + '</div>');
				ayk.unshift('<div class="white">' + spin + '</div>');
				ayk.unshift('<div class="row">');

			} else {
				ayk.push('<div class="row">');
				ayk.push('<div class="white">' + spin + '</div>');
				ayk.push('<div class="' + getNumColor(n[0]) + '">' + n[0] + '</div>');
				ayk.push('<div class="white">' + clStreight + '</div>');
				ayk.push('<div class="' + getNumColor(n[1]) + '">' + n[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclStreight + '</div>');
				ayk.push('<div class="color' + (split[0] - 1) + '">' + split[0] + '</div>');
				ayk.push('<div class="white">' + clSplit + '</div>');
				ayk.push('<div class="color' + (split[1] - 1) + '">' + split[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclSplit + '</div>');
				ayk.push('<div class="color' + (street[0] - 1) + '">' + street[0] + '</div>');
				ayk.push('<div class="white">' + clStreet + '</div>');
				ayk.push('<div class="color' + (street[1] - 1) + '">' + street[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclStreet + '</div>');
				ayk.push('<div class="color' + (line[0] - 1) + '">' + line[0] + '</div>');
				ayk.push('<div class="white">' + clLine + '</div>');
				ayk.push('<div class="color' + (line[1] - 1) + '">' + line[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclLine + '</div>');
				ayk.push('<div class="color' + (quad[0] - 1) + '">' + quad[0] + '</div>');
				ayk.push('<div class="white">' + clQuad + '</div>');
				ayk.push('<div class="color' + (quad[1] - 1) + '">' + quad[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclQuad + '</div>');
				ayk.push('<div class="color' + (doz[0] - 1) + '">' + doz[0] + '</div>');
				ayk.push('<div class="white">' + clDoz + '</div>');
				ayk.push('<div class="color' + (doz[1] - 1) + '">' + doz[1] + '</div>');
				ayk.push('<div style="margin-right: 2px" class="white">' + pclDoz + '</div>');
				ayk.push('<div class="color' + highlow[0] + '">' + highlow[0] + '</div>');
				ayk.push('<div class="white">' + clHL + '</div>');
				ayk.push('<div class="color' + highlow[1] + '">' + highlow[1] + '</div>');
				ayk.push('<div class="white">' + pclHL + '</div>');
				ayk.push('</div>');
			}
		}
	}

	$('.stream').html(ayk.join(''));

	$('.streamSplit').html('');
	for (var i = 1; i <= 18; i++) {
		$('.streamSplit').append('<div>' + streamSplit[i-1] + '</div>');
	}

	$('.streamStreet').html('');
	for (i = 1; i <= 12; i++) {
		$('.streamStreet').append('<div>' + streamStreet[i-1] + '</div>');
	}

	$('.streamLine').html('');
	for (i = 1; i <= 6; i++) {
		$('.streamLine').append('<div>' + streamLine[i-1] + '</div>');
	}

	$('.streamQuad').html('');
	for (i = 1; i <= 4; i++) {
		$('.streamQuad').append('<div>' + streamQuad[i-1] + '</div>');
	}

	$('.streamDoz').html('');
	for (i = 1; i <= 3; i++) {
		$('.streamDoz').append('<div>' + streamDoz[i-1] + '</div>');
	}
}




function loadStreams() {
	for (var i = 1; i <= 18; i++) {
		$('.streamSplitHead').append('<div>' + i + '</div>');
	}
	for (i = 1; i <= 12; i++) {
		$('.streamStreetHead').append('<div>' + i + '</div>');
	}
	for (i = 1; i <= 6; i++) {
		$('.streamLineHead').append('<div>' + i + '</div>');
	}
	for (i = 1; i <= 4; i++) {
		$('.streamQuadHead').append('<div>' + i + '</div>');
	}
	for (i = 1; i <= 3; i++) {
		$('.streamDozHead').append('<div>' + i + '</div>');
	}
	// for (i = 1; i <= 2; i++) {
	// 	$('.streamHLHead').append('<div>' + i + '</div>');
	// }
}